/*
 * Reza Naghibi
 * Weather Channel 2011
 * 
 */

#ifndef _WX_DTREE_H_INCLUDED_
#define _WX_DTREE_H_INCLUDED_


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <time.h>
#include <sys/time.h>


#define DTREE_CLIENT_VER        "1.4pub"


//if enabled, this packs system pointers into 16/32 bits
#define DTREE_DT_PACKED         1

//if PACKED is enabled, uses 16bit pointers, otherwise 32bit
#define DTREE_DT_PACKED_16      1


//debug stuff
#define DTREE_PERF_UALOOKUP     0
#define DTREE_PERF_WALKING      0

//enable logging
#define DTREE_DEBUG_LOGGING     0

//logging constants
#define DTREE_PRINT_GENERIC     (1 << 0)
#define DTREE_PRINT_CLASSIFY    (1 << 1)
#define DTREE_PRINT_INITDTREE   (1 << 2)

//what messages to print, DEBUG_LOGGING needs to be enabled
#define DTREE_PRINT_ENABLED     (DTREE_PRINT_GENERIC | DTREE_PRINT_CLASSIFY)


#if DTREE_DT_PACKED

#if DTREE_DT_PACKED_16
//16bit pointer, 6 bits max for SLABS (max=64)
typedef unsigned short int packed_ptr;
#define DTREE_DT_MAX_SLABS      64
#else
//32bit pointer, 22 bits max for SLABS (max=4194304)
typedef unsigned int packed_ptr;
#define DTREE_DT_MAX_SLABS      1024
#endif /*DTREE_DT_PACKED_16*/

#define DTREE_DT_SLAB_SIZE      1024
#define DTREE_DT_GETPPH(PP)     ((PP)>>10)
#define DTREE_DT_GETPPL(PP)     ((PP)&0x3FF)
#define DTREE_DT_GETPP(H,PP)    (&((dtree_dt_node*)(H)->slabs[DTREE_DT_GETPPH(PP)])[DTREE_DT_GETPPL(PP)])
#define DTREE_DT_GENPP(P,H,L)   ((H)<<10)|L;

#else /*NOT DTREE_DT_PACKED*/

//it is safe to change the values for SLABS
#define DTREE_DT_MAX_SLABS      1024
#define DTREE_DT_SLAB_SIZE      1024

#define DTREE_DT_GETPP(H,PP)    ((dtree_dt_node*)PP)
#define DTREE_DT_GENPP(P,H,L)   ((packed_ptr)P);

#endif /*DTREE_DT_PACKED*/


//dtree flags
#define DTREE_DT_FLAG_TOKEN     (1 << 0)
#define DTREE_DT_FLAG_STRONG    (1 << 1)
#define DTREE_DT_FLAG_WEAK      (1 << 2)
#define DTREE_DT_FLAG_NONE      (1 << 3)


//dynamic classification
#define DTREE_DT_MIN_TLEN       6
#define DTREE_DT_DCLEN          32
#define DTREE_DT_FLAG_CPOS      4
#define DTREE_DT_MAX_FLAGS      31-DTREE_DT_FLAG_CPOS


//dtree dtnode
typedef struct
{
    char             data;
    int              flags;
#if DTREE_DT_PACKED
    packed_ptr       nodes[36];
#else
    struct           dtree_dt_node *nodes[36];
#endif
}
dtree_dt_node;


//master dtree node
typedef struct
{
    dtree_dt_node    head;
    
    unsigned int     node_count;
    long             size;
    
    unsigned int     slab_count;
    unsigned int     slab_pos;
    void             *slabs[DTREE_DT_MAX_SLABS];
    
    int              dclass_count;
    char             dclasses[DTREE_DT_MAX_FLAGS][DTREE_DT_DCLEN+1];
}
dtree_dt_head;

//if not packed_ptr, define this as normal node
#if !DTREE_DT_PACKED
typedef struct dtree_dt_node* packed_ptr;
#endif

//declarations
int load_dtree(dtree_dt_head*,char*);
const char *dtree_classify(const dtree_dt_head*,const char*);
void init_dtree_head(dtree_dt_head*);
void free_dtree(dtree_dt_head*);
long print_dtree(const dtree_dt_head*);
void dttimersubn(struct timespec *end,struct timespec *start,struct timespec *result);


#endif /* _WX_DTREE_H_INCLUDED_ */
