/*
 * Reza Naghibi
 * Weather Channel 2011
 * 
 */

#include "dtree_client.h"

int main(int argc,char **args)
{
    int ret,i;
    long lval,count,ttime;
    const char *s;
    char buf[1024];
    char *loadFile="../dtrees/wurfl.dtree";
    char *parameter=NULL;
    struct timespec startn,endn,diffn,total;
    dtree_dt_head HEAD;
    
    printf("WURFL dtree client\n");
    
    for(i=1;i<argc;i++)
    {
        //-l [dtree file] on command line
        if(!strcmp(args[i],"-l") && argc>(++i))
            loadFile=args[i];
        else
            parameter=args[i];
    }

    printf("Loading dtree: '%s'\n",loadFile);
    
    clock_gettime(CLOCK_REALTIME,&startn);
    ret=load_dtree(&HEAD,loadFile);
    clock_gettime(CLOCK_REALTIME,&endn);
    dttimersubn(&endn,&startn,&diffn);
    
    printf("load dtree tokens: %d time: %lds %ldms %ldus %ldns\n",ret,diffn.tv_sec,diffn.tv_nsec/1000000,diffn.tv_nsec/1000%1000,diffn.tv_nsec%1000);
    
    printf("dtree stats: nodes: %d slabs: %d mem: %ld bytes\n",HEAD.node_count,HEAD.slab_count,HEAD.size);
    
    clock_gettime(CLOCK_REALTIME,&startn);
    lval=print_dtree(&HEAD);
    clock_gettime(CLOCK_REALTIME,&endn);
    dttimersubn(&endn,&startn,&diffn);
    
    printf("walk tree: %ld tokens %d nodes time: %lds %ldms %ldus %ldns\n",lval,HEAD.node_count,diffn.tv_sec,diffn.tv_nsec/1000000,diffn.tv_nsec/1000%1000,diffn.tv_nsec%1000);
    
    clock_gettime(CLOCK_REALTIME,&startn);
    s=dtree_classify(&HEAD,"Mozilla/5.0 (Linux; U; Android 2.2; en; HTC Aria A6380 Build/ERE27) AppleWebKit/540.13+ (KHTML, like Gecko) Version/3.1 Mobile Safari/524.15.0");
    clock_gettime(CLOCK_REALTIME,&endn);
    dttimersubn(&endn,&startn,&diffn);
    
    printf("HTC Aria UA lookup: '%s' time: %lds %ldms %ldus %ldns\n",s,diffn.tv_sec,diffn.tv_nsec/1000000,diffn.tv_nsec/1000%1000,diffn.tv_nsec%1000);
    
    if(parameter)
    {
        FILE *f;
        
        if((f=fopen(parameter,"r")))
        {
            long llvm=0;
            printf("UA file: '%s'\n",parameter);
            
            count=0;
            memset(&total,0,sizeof(total));
            
            while(fgets(buf,sizeof(buf),f))
            {
#if DTREE_PERF_UALOOKUP
                int slen=strlen(buf)-1;
                if(buf[slen]=='\n')
                    buf[slen]='\0';
                printf("UA: '%s'\n",buf);
                fflush(stdout);
#endif

                clock_gettime(CLOCK_REALTIME,&startn);
                s=dtree_classify(&HEAD,buf);
                clock_gettime(CLOCK_REALTIME,&endn);
                dttimersubn(&endn,&startn,&diffn);
                
                total.tv_sec+=diffn.tv_sec;
                total.tv_nsec+=diffn.tv_nsec;
                count++;
                
                llvm+=*s;

#if DTREE_PERF_UALOOKUP
                printf("UA lookup %ld: '%s' time: %lds %ldms %ldus %ldns\n",count,s,diffn.tv_sec,diffn.tv_nsec/1000000,diffn.tv_nsec/1000%1000,diffn.tv_nsec%1000);
#endif
            }
            
            fclose(f);
            
            ttime=(total.tv_sec*1000*1000*1000)+total.tv_nsec;
            ttime/=count;
            
            llvm/=count;
            if(llvm>256)
                return 1;
            
            printf("TOTAL average time: %ld lookups, %lds %ldms %ldus %ldns\n",count,ttime/1000000000,ttime/1000000%1000000,ttime/1000%1000,ttime%1000);
        }
        else
        {
            printf("UA: '%s'\n",parameter);
            
            clock_gettime(CLOCK_REALTIME,&startn);
            s=dtree_classify(&HEAD,parameter);
            clock_gettime(CLOCK_REALTIME,&endn);
            dttimersubn(&endn,&startn,&diffn);

            printf("Param UA lookup: '%s' time: %lds %ldms %ldus %ldns\n",s,diffn.tv_sec,diffn.tv_nsec/1000000,diffn.tv_nsec/1000%1000,diffn.tv_nsec%1000);
        }
    }

    return 0;
}
